/*
*  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
*
*  This file is part of the Arnold emulator source code distribution.
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include "labelset.h"

static LabelSetManager globalLabelSetManager;

const LabelSetManager &getGlobalLabelSetManager()
{
	return globalLabelSetManager;
}


LabelSetManager &getGlobalLabelSetManagerRef()
{
	return globalLabelSetManager;
}

bool LabelSetManager::addLabelToCurrentLabelSet(const std::string &sName, Z80_WORD Addr)
{
	if (!m_current)
		return false;

	m_current->addLabel(sName, Addr);
	return true;
}

LabelSet *LabelSetManager::addEmptyLabelSet(const std::string &sName)
{
	LabelSet *labelSet = new LabelSet();
	if (labelSet!=nullptr)
	{
		labelSet->setName(sName);
		m_labelsets.push_back(labelSet);
	}
	return labelSet;
}

LabelSet *LabelSetManager::findLabelSetByName(const std::string &sName)
{
	LabelSetsType::iterator iter = m_labelsets.begin();
	for (; iter != m_labelsets.end(); ++iter)
	{
		LabelSet *labelSet = (*iter);

		if (labelSet->getName() == sName)
			return labelSet;
	}
	return nullptr;
}




bool LabelSetManager::getLabelNameByAddr(const Z80_WORD Addr, std::string &sName) const
{
	LabelSetsType::const_iterator iter = m_labelsets.begin();
	for (; iter != m_labelsets.end(); ++iter)
	{
		const LabelSet *labelSet = (*iter);

		if (!labelSet->isActive())
		{
			continue;
		}

		if (labelSet->getLabelNameByAddr(Addr, sName))
			return true;
	}
	return false;
}


bool LabelSetManager::getLabelAddrByName(const std::string &sName, Z80_WORD &Addr) const
{
	LabelSetsType::const_iterator iter = m_labelsets.begin();
	for (; iter != m_labelsets.end(); ++iter)
	{
		const LabelSet *labelSet = (*iter);

		if (!labelSet->isActive())
		{
			continue;
		}

		if (labelSet->getLabelAddrByName(sName, Addr))
			return true;
	}
	return false;
}


bool LabelSet::getLabelNameByAddr(const Z80_WORD Addr, std::string &sName) const
{
	LabelsType::const_iterator iter = m_labels.begin();
	for (; iter != m_labels.end(); ++iter)
	{
		const Label *label = (*iter);

		if (!label->isActive())
		{
			continue;
		}
		if (label->getAddress() == Addr)
		{
			sName = label->getName();
			return true;
		}
	}
	return false;
}


bool LabelSet::getLabelAddrByName(const std::string &sName, Z80_WORD &Addr) const
{
	LabelsType::const_iterator iter = m_labels.begin();
	for (; iter != m_labels.end(); ++iter)
	{
		const Label *label = (*iter);

		if (!label->isActive())
		{
			continue;
		}
		if (strcmp(label->getName().c_str(), sName.c_str())==0)
		{ 
			Addr = label->getAddress();
			return true;
		}
	}
	return false;
}

Label *LabelSet::addLabel(const std::string &sName, Z80_WORD Addr)
{
	Label *label = new Label();
	if (label != nullptr)
	{
		label->setName(sName);
		label->setAddress(Addr);
		label->setActive(true);
		m_labels.push_back(label);
	}
	return label;
}

void LabelSet::deleteLabel(Label *labelToDelete)
{
	LabelsType::iterator iter = m_labels.begin();
	for (; iter != m_labels.end(); ++iter)
	{
		Label *label = (*iter);
		if (label == labelToDelete)
		{
			delete label;
			m_labels.erase(iter);
			return;
		}
	}
}

void LabelSetManager::deleteLabelSet(LabelSet *labelSetToDelete)
{
	LabelSetsType::iterator iter = m_labelsets.begin();
	for (; iter != m_labelsets.end(); ++iter)
	{
		LabelSet *labelSet = (*iter);
		if (labelSet == labelSetToDelete)
		{
			delete labelSet;
			m_labelsets.erase(iter);
			return;
		}
	}
}


